#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include  <CommonCrypto/CommonCryptor.h>
#include <string.h>
#include <CoreFoundation/CoreFoundation.h>
#include "sandbox.h"
#include <pthread.h>
#include <sys/types.h>
#include <atomic>
#include <sys/socket.h>
#include <queue>
#include <map>
#define DYLD_INTERPOSE(_replacment,_replacee) \
__attribute__((used)) static struct{ const void* replacment; const void* replacee; } _interpose_##_replacee \
__attribute__ ((section ("__DATA,__interpose"))) = { (const void*)(unsigned long)&_replacment, (const void*)(unsigned long)&_replacee };

struct cryptoargs {
    CCOperation     op;
    CCMode            mode;
    CCAlgorithm        alg;
    CCPadding        padding;
    void         *iv = 0;            /* optional initialization vector */
    void         *key;            /* raw key material */
    size_t             keyLength;
    const void         *tweak;            /* raw tweak material */
    size_t             tweakLength;
    int                numRounds;        /* 0 == default */
    CCModeOptions     options;
};


std::queue<cryptoargs> vidargs;
std::queue<cryptoargs> audargs;
std::queue<cryptoargs> aud68;
std::queue<cryptoargs> aud77;
std::map<CCCryptorRef,cryptoargs> firstmap;
std::map<int,cryptoargs> secondmap;
CCCryptorRef    vidRef;
char* vidkey = 0;
char* audkey = 0;
char* vidiv = 0;
char* audiv = 0;


CCCryptorStatus myCCCryptorCreateWithMode(
                                          CCOperation     op,                /* kCCEncrypt, kCCEncrypt, kCCBoth (default for BlockMode) */
                                          CCMode            mode,
                                          CCAlgorithm        alg,
                                          CCPadding        padding,
                                          const void         *iv,            /* optional initialization vector */
                                          const void         *key,            /* raw key material */
                                          size_t             keyLength,
                                          const void         *tweak,            /* raw tweak material */
                                          size_t             tweakLength,
                                          int                numRounds,        /* 0 == default */
                                          CCModeOptions     options,
                                          CCCryptorRef    *cryptorRef){
    
    dispatch_queue_t queue = dispatch_get_current_queue();
    const char * name =  dispatch_queue_get_label(queue);
    FILE* hFile;
    char name2[1024];
    pthread_t         self;
    self = pthread_self();
    pthread_getname_np(self, name2, 1024);
    
    if ((strcmp(name,  "com.apple.VideoConference.videoTransmit") == 0)){
        cryptoargs g;
        g.op = op;
        g.mode = mode;
        g.alg = alg;
        g.padding = padding;
        
        g.iv = malloc(32);
        memcpy(g.iv, iv, 32);
        g.key = malloc(keyLength);
        g.keyLength = keyLength;
        memcpy(g.key, key, keyLength);
        g.tweak = tweak;
        g.tweakLength = tweakLength;
        g.numRounds = numRounds;
        g.options = options;
        vidargs.push(g);
        //if(!vkey){
        // vkey = malloc(keyLength);
        //memcpy(vkey, key, keyLength);
        //CCCryptorCreateWithMode(op, mode, alg, padding, iv, key, keyLength, tweak, tweakLength, numRounds, options, &vidRef);
        
        //}else{
        //  if(memcmp(key, vkey, keyLength)!=0){
        //    abort();
        // }
        // }
        printf("v");
    }
    
    if((strcmp(name2,  "com.apple.avconference.packetThread.com.apple.AVConference.auio") == 0)){
        cryptoargs g;
        g.op = op;
        g.mode = mode;
        g.alg = alg;
        g.padding = padding;
        
        g.iv = malloc(32);
        memcpy(g.iv, iv, 32);
        g.key = malloc(keyLength);
        g.keyLength = keyLength;
        memcpy(g.key, key, keyLength);
        g.tweak = tweak;
        g.tweakLength = tweakLength;
        g.numRounds = numRounds;
        g.options = options;
        audargs.push(g);
        // if(!akey){
        // akey = malloc(keyLength);
        // memcpy(akey, key, keyLength);
        // CCCryptorCreateWithMode(op, mode, alg, padding, iv, key, keyLength, tweak, tweakLength, numRounds, options, &audRef);
        
        //}else{
        //  if(memcmp(key, akey, keyLength)!=0){
        //    abort();
        //}
        // }
    }
    
    CCCryptorStatus s = CCCryptorCreateWithMode(op, mode, alg, padding, iv, key, keyLength, tweak, tweakLength, numRounds, options, cryptorRef);
    
    return s;
    
}

DYLD_INTERPOSE(myCCCryptorCreateWithMode, CCCryptorCreateWithMode);

CCCryptorStatus mycryptor(
	CCCryptorRef cryptorRef,
	const void *dataIn,
	size_t dataInLength,
	void *dataOut,				
	size_t dataOutAvailable,
	size_t *dataOutMoved);

DYLD_INTERPOSE(mycryptor, CCCryptorUpdate);


int msgloop = 14428;
int seq = 0;
int hseq = 0;
int seq1 = 0;
int hseq1 = 0;
int sinit = 0;
int vinit = 0;
int ainit1 = 0;
int ainit2 = 0;
char vidssrc[4];
char assrc1[4];
char assrc2[4];
char vidseq[2];
char aseq1[2];
char aseq2[2];
int started = 0;


static std::atomic_flag spinlock2 = ATOMIC_FLAG_INIT;

ssize_t mysendmsg(int sockfd, const struct msghdr *msg, int flags){
  char name2[1024];
    pthread_t         self;
    self = pthread_self();
    pthread_getname_np(self, name2, 1024);

    if(strcmp(name2,  "com.apple.avconference.mediaqueue.sendproc") == 0){
        while (atomic_flag_test_and_set_explicit(&spinlock2,
                                                 std::memory_order_acquire)) {}
        started = 1;
        char l[1024];
        sprintf(l, "/out/sent%d", msgloop);
        FILE* w = fopen(l, "wb");
        char* yy = "a";
        fwrite(yy, 1, 1, w);
        fclose(w);
            
        bool audio = false;
        char name[1024];
        if(msg->msg_iovlen > 1){
            char* pack = (char*) msg->msg_iov[1].iov_base;


            if(!sinit){
                char payload = pack[1];
                payload = payload & 0x7f;
                if ( payload == '\x7b'){
                if(!vinit){
                    memcpy(&vidssrc, pack + 8, 4);
                    memcpy(&vidseq, pack + 2, 2);
                    if ( seq == 0){
                        
                        ((char*)&seq)[0] = pack[3];
                        ((char*)&seq)[1] = pack[2];
                        
                    }
                    vinit = 1;
                    }
                } else if ( payload == '\x68'){
                    if(!ainit1){
                        if ( seq1 == 0){
                            
                            ((char*)&seq1)[0] = pack[3];
                            ((char*)&seq1)[1] = pack[2];
                            
                        }
                        memcpy(&assrc1, pack + 8, 4);
                        memcpy(&aseq1, pack + 2, 2);
                        ainit1 = 1;
                    }
                } else if ( payload == '\x77'){
                    if(!ainit2){
                        if ( seq1 == 0){
                            
                            ((char*)&seq1)[0] = pack[3];
                            ((char*)&seq1)[1] = pack[2];
                            
                        }
                        memcpy(&assrc2, pack + 8, 4);
                        memcpy(&aseq2, pack + 2, 2);
                        ainit2 = 1;
                    }
                }else{
                    abort();
                }

                if(vinit==1 && ainit1 == 1 && ainit2 == 1){
                        
                    sinit = 1;
                }
                    
            }
            started = 1;
            sprintf(name, "/out/extra_%d", msgloop);

            FILE* f = 0;
            f = fopen(name, "rb");
            if(!f){
                
                msgloop = 23000;
                sprintf(name, "/out/extra_%d", msgloop);
                f = fopen(name, "rb");
                
            }
            size_t size = 0;
            char* mes = 0;
            fseek(f, 0L, SEEK_END);
            size = ftell(f);
            rewind(f);
            mes = (char*)malloc(size);
            fread(mes, size, 1, f);
            fclose(f);

           char* m = (char*) malloc(size);

            m[0] = mes[0];
            m[1] = mes[1];
            m[4] = mes[4]; //keep timestamp
            m[5] = mes[5];
            m[6] = mes[6];
            m[7] = mes[7];
                

            char payload = mes[1] & 0x7f;
                
            if( payload == 0x7b){
                
                if(seq==0){
                    atomic_flag_clear_explicit(&spinlock2, std::memory_order_release);
                    return 100;
                }
                if ( hseq == 0){
                    
                    ((char*)&hseq)[0] = mes[3];
                    ((char*)&hseq)[1] = mes[2];
                    
                }
                
                int cseq = 0;
                
                ((char*)&cseq)[0] = mes[3];
                ((char*)&cseq)[1] = mes[2];
                int nseq = seq + (cseq - hseq);
                m[3] = nseq & 0xff;
                m[2] = (nseq & 0xff00) >> 8;
                memcpy(m+8, &vidssrc, 4);
            }else{
                
                if(seq1==0){
                    atomic_flag_clear_explicit(&spinlock2, std::memory_order_release);
                    return 100;
                }
                    

                if ( hseq1 == 0){
                        
                    ((char*)&hseq1)[0] = mes[3];
                    ((char*)&hseq1)[1] = mes[2];
                        
                }
                    
                int cseq = 0;
                    
                ((char*)&cseq)[0] = mes[3];
                ((char*)&cseq)[1] = mes[2];
                int nseq = seq1 + (cseq - hseq1);
                m[3] = nseq & 0xff;
                m[2] = (nseq & 0xff00) >> 8;
                    
                if((payload == 0x68)&&ainit1){
                    memcpy(m+8, &assrc1, 4);
                }else if(ainit2){
                    memcpy(m+8, &assrc2, 4);
                        
                }
                    
            }
                    
            memcpy(m+12, mes+12, size - 12);

            int offset = 12;
            char h = m[0];
            if(h & 0x10){
                int extlen = m[15];
                offset = offset + 4 + extlen*4;
            }
            
          /*  int oldoffset = 12;
            char oh = pack[0];
            if(oh & 0x10){
                int oldextlen = pack[15];
                oldoffset = oldoffset + 4 + oldextlen*4;
            }
            
            size_t o;
            int mind = *((int*)(pack + oldoffset));
            char oldpayload = pack[1] & 0x7f;
            if(oldpayload == '\x7b'){
                
                //nothing
            }else if(oldpayload == '\x68'){
                auto it = secondmap.find(mind);
                
                if(it == secondmap.end()){
                    
                    abort();
                }
                
                aud77.push(secondmap[mind]);
                
            }else{
                auto it = secondmap.find(mind);
                if(it == secondmap.end()){
                    
                    abort();
                }
                
                aud77.push(secondmap[mind]);
            }*/
            size_t o;
            payload = m[1] & 0x7f;
            if(payload == '\x7b'){
                if(vidargs.size() == 0){
                    atomic_flag_clear_explicit(&spinlock2, std::memory_order_release);
                    return 100;
                }
                
                cryptoargs g = vidargs.front();
                vidargs.pop();
                CCCryptorStatus s = CCCryptorCreateWithMode(g.op, g.mode, g.alg, g.padding, g.iv, g.key, g.keyLength, g.tweak, g.tweakLength, g.numRounds, g.options, &vidRef);
                
                CCCryptorUpdate(vidRef, m+ offset, size - offset, m+ offset, size -offset, &o);
                free(g.iv);
                free(g.key);
                
                CCCryptorRelease(vidRef);
              //  free(g.iv);
              //  free(g.key);
                    

            /*} else if(payload == '\x68'){
                if(aud68.size() == 0){
                    atomic_flag_clear_explicit(&spinlock2, std::memory_order_release);
                    return 100;
                }
                cryptoargs g = aud68.front();
                aud68.pop();
                CCCryptorStatus s = CCCryptorCreateWithMode(g.op, g.mode, g.alg, g.padding, g.iv, g.key, g.keyLength, g.tweak, g.tweakLength, g.numRounds, g.options, &vidRef);
                    
                CCCryptorUpdate(vidRef, m+ offset, size - offset, m+ offset, size - offset, &o);
                free(g.iv);
                free(g.key);
                    
                CCCryptorRelease(vidRef);*/
                    
            }else{
                if(audargs.size() == 0){
                    atomic_flag_clear_explicit(&spinlock2, std::memory_order_release);
                    return 100;
                }
                cryptoargs g = audargs.front();
                audargs.pop();
                CCCryptorStatus s = CCCryptorCreateWithMode(g.op, g.mode, g.alg, g.padding, g.iv, g.key, g.keyLength, g.tweak, g.tweakLength, g.numRounds, g.options, &vidRef);
                
                CCCryptorUpdate(vidRef, m+ offset, size - offset, m+ offset, size -offset, &o);
                free(g.iv);
                free(g.key);
                
                CCCryptorRelease(vidRef);
            }
            msg->msg_iov[1].iov_base = m;
            msg->msg_iov[1].iov_len  = size;
            fclose(f);

            ((char*)msg->msg_iov[0].iov_base)[2] = (((size) & 0xff00) >> 8);
            ((char*)msg->msg_iov[0].iov_base)[3] = (size) & 0xff; //correct the STUN size
        }else{
            
            abort();
        }

        msgloop++;
        
        atomic_flag_clear_explicit(&spinlock2, std::memory_order_release);
    return sendmsg(sockfd, msg, flags);
        }
    
 //   if(!started){
    return sendmsg(sockfd, msg, flags);
   // }else{
     //
       // return 100;
   // }

}

bool vidset = false;
bool audset = false;
DYLD_INTERPOSE(mysendmsg, sendmsg);


int loop = 0;



static std::atomic_flag spinlock = ATOMIC_FLAG_INIT;
CCCryptorStatus mycryptor(
	CCCryptorRef cryptorRef,
	const void *dataIn,
	size_t dataInLength,
	void *dataOut,				
	size_t dataOutAvailable,
	size_t *dataOutMoved) {

    while (atomic_flag_test_and_set_explicit(&spinlock,
                                             std::memory_order_acquire)) {
    }
    char* m = 0;
    dispatch_queue_t queue = dispatch_get_current_queue();
    const char * name =  dispatch_queue_get_label(queue);
    FILE* hFile;
    char name2[1024];
    pthread_t         self;
    self = pthread_self();
    pthread_getname_np(self, name2, 1024);
    int vid = 0;
    char* dataInCopy = 0;
    if ((strcmp(name,  "com.apple.VideoConference.videoTransmit") == 0)){
        
  

       //*((unsigned int *)((char*)dataIn + 0x650)) = (unsigned int) dataInLength;
    }
    
    if ((strcmp(name2,  "com.apple.avconference.packetThread.com.apple.AVConference.auio") == 0)){
        
        vid = 1;

        
       // *((unsigned int *)((char*)dataIn + 0x650)) = (unsigned int) dataInLength;
    }

    CCCryptorStatus s;
   /* if(vid){
        
        s = CCCryptorUpdate(cryptorRef, dataIn, dataInLength, dataOut, dataOutAvailable, dataOutMoved);

        int mes = *((int*)dataIn);
        auto it = firstmap.find(cryptorRef);
        
        if(it == firstmap.end()){
            
            abort();
        }
        cryptoargs t = firstmap[cryptorRef];
        secondmap[mes] = t;

    }else{*/
    s = CCCryptorUpdate(cryptorRef, dataIn, dataInLength, dataOut, dataOutAvailable, dataOutMoved);

    //}
   atomic_flag_clear_explicit(&spinlock, std::memory_order_release);
    return s;
    
}



